package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.util.ArrayList;

public class WidgetScreenPaletteObject extends ScreenPaletteObject {
	
	
	private CustomImageDataII imageArray[];
	private ArrayList<ScreenObject> allCreatedObjects;
	
	public WidgetScreenPaletteObject(IntRect theClickRect, 
									 int theDistanceToBorder, 
									 int theBorderWidth, 
									 CustomImageDataII [] theImageArray) {
		
		clickRect = theClickRect;
		imageArray = theImageArray;
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;

		allCreatedObjects = new ArrayList<ScreenObject>();
		
	}
	
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		WidgetScreenObject returnValue = new WidgetScreenObject(objX, objY, this);
		allCreatedObjects.add(returnValue);
		return returnValue;
	}

	@Override
	public void draw(Graphics g) {
		
		if(clickRect == null || imageArray == null || imageArray.length == 0)
			return;
		
		Point p = clickRect.getCenter();
		
		imageArray[0].drawObjectIgnoreBounds(g, p.x, p.y);
		
		Color origCol = g.getColor();
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
		
	}
	
	public void setImages(CustomImageDataII newImageArray[]) {
		if(newImageArray == null)
			return;
		imageArray = newImageArray;
	}
	
	public CustomImageDataII [] getImageArray() {
		return imageArray;
	}


	@Override
	public void delete(ScreenObject so) {

		for(int i = 0; i < allCreatedObjects.size(); i++) {
			if(allCreatedObjects.get(i).equals(so)) {
				allCreatedObjects.remove(i);
				return;
			}
		}
		
	}
	
	
	
	public void altered() {
		
		int width = imageArray[0].getDesiredWidth();
		int height = imageArray[0].getDesiredHeight();
		
		ScreenObject so = null;
		IntRect origRect = null;
		IntRect newRect = null;
		Point center = null;
		
		for(int i = 0; i < allCreatedObjects.size(); i++) {
			so = allCreatedObjects.get(i);
			origRect = so.getClickRect();
			if(origRect.width() == width && origRect.height() == height)
				continue;
			center = origRect.getCenter();
			newRect = new IntRect(center.x - width/2, center.y - height/2, width, height);
			so.setClickRect(newRect);
			
				
		}
		
	}
	
	public void addCreatedObject(WidgetScreenObject wso) {
		allCreatedObjects.add(wso);
	}
	
	
}
